/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.settings.network.config;

import com.ibm.hwmca.base.settings.network.config.DHCPServerRangeConfig;
import com.ibm.hwmca.base.settings.network.config.NetworkApplicationConfig;
import com.ibm.hwmca.base.settings.network.config.NetworkInterfaceConfig;
import com.ibm.hwmca.base.settings.network.config.NetworkSettingsConfig;
import com.ibm.hwmca.base.settings.network.config.PortConfig;
import com.ibm.hwmca.fw.util.CommonXMLParser;
import com.ibm.hwmca.fw.util.MalformedXMLException;
import com.ibm.hwmca.fw.util.Trace;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;

public class NetworkSettingsConfigParser
extends CommonXMLParser {
    private static final String TRACE_MASKT = "XSETNCFT";
    private static final String TRACE_MASKF = "XSETNCFF";
    private static final String TRACE_MASKD = "XSETNCFD";
    private static final String TAG_NETWORK_CONFIG = "network_config";
    private static final String TAG_NAME_BUNDLE = "name_bundle";
    private static final String TAG_NET_APP = "net_app";
    private static final String TAG_PORT = "port";
    private static final String TAG_INTERFACE = "interface";
    private static final String TAG_DHCPD_RANGE = "dhcpd_range";
    private static final String TAG_OFFER_FEATURE = "offer_feature";
    private static final String TAG_REMOTE_ACCESS = "remote_access";
    private static final String ATTRIB_NAME = "name";
    private static final String ATTRIB_APP_ID = "app_id";
    private static final String ATTRIB_PUBLIC_DEFAULT = "public_default";
    private static final String ATTRIB_PRIVATE_DEFAULT = "private_default";
    private static final String ATTRIB_NUMBER = "number";
    private static final String ATTRIB_TYPE = "type";
    private static final String ATTRIB_INTERFACE_ID = "interface_id";
    private static final String ATTRIB_IP_ADDRESS = "ip_address";
    private static final String ATTRIB_VISIBLE = "visible";
    private static final String ATTRIB_LPAR_COMMUNICATION = "lpar_communication";
    private static final String ATTRIB_HMC_ADDRESS = "hmc_address";
    private static final String ATTRIB_START = "start";
    private static final String ATTRIB_END = "end";
    private static final String ATTRIB_SUBNET = "subnet";
    private static final String ATTRIB_MASK = "mask";
    private static final String ATTRIB_OFFER = "offer";
    private static final String ATTRIB_ALLOW = "allow";
    private static final String VALUE_LPAR_CHECKBOX = "lpar_checkbox";
    private static final String VALUE_TRUE = "true";
    private static final String VALUE_FALSE = "false";
    private static final String VALUE_FIXED_PUBLIC = "fixed_public";
    private static final String VALUE_FIXED_PRIVATE = "fixed_private";
    private static final String VALUE_CUSTOMER_CHOICE = "customer_choice";
    private static final String VALUE_FIXED = "fixed";
    private static final String VALUE_DHCP_CLIENT = "dhcp_client";
    private static final String VALUE_DHCP_SERVER = "dhcp_server";
    private static final String VALUE_ALLOW = "allow";
    private static final String VALUE_DENY = "deny";
    private static final String VALUE_TCP = "tcp";
    private static final String VALUE_UDP = "udp";

    private NetworkSettingsConfigParser() throws SAXNotRecognizedException, SAXNotSupportedException {
        Trace.trace(TRACE_MASKT, "<>NetworkSettingsConfigParser.c-tor");
    }

    public static void parseXML(String fileName, NetworkSettingsConfig nsConfig) throws MalformedXMLException {
        NetworkSettingsConfigParser.parseXML(new File(fileName), nsConfig);
    }

    public static void parseXML(File file, NetworkSettingsConfig nsConfig) throws MalformedXMLException {
        Trace.trace(TRACE_MASKT, "-> NetworkSettingsConfigParser.parseXML(" + file + ")");
        try {
            nsConfig.init();
            NetworkSettingsConfigParser parser = new NetworkSettingsConfigParser();
            parser.parse(new InputSource(new FileInputStream(file)));
            Document doc = parser.getDocument();
            NodeList nsChildren = doc.getElementsByTagName(TAG_NETWORK_CONFIG);
            if (nsChildren.getLength() != 1) {
                throw new MalformedXMLException("A single <network_config> is expected.");
            }
            NetworkSettingsConfigParser.parseNetworkConfig(nsChildren.item(0), nsConfig);
        }
        catch (IOException e) {
            throw new MalformedXMLException("IOException reading file");
        }
        catch (SAXParseException e) {
            throw new MalformedXMLException("SaxParseException!: " + CommonXMLParser.where(e));
        }
        catch (SAXException e) {
            throw new MalformedXMLException("SaxException! " + e);
        }
        Trace.trace(TRACE_MASKT, "<- NetworkSettingsConfigParser.parseXML(" + file + ")");
    }

    private static void parseNetworkConfig(Node node, NetworkSettingsConfig nsConfig) throws MalformedXMLException {
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeType() == 1) {
                String curElement = child.getNodeName().toLowerCase();
                if (TAG_NAME_BUNDLE.equals(curElement)) {
                    NetworkSettingsConfigParser.parseNameBundle(child, nsConfig);
                } else if (TAG_NET_APP.equals(curElement)) {
                    NetworkSettingsConfigParser.parseNetApp(child, nsConfig);
                } else if (TAG_INTERFACE.equals(curElement)) {
                    NetworkSettingsConfigParser.parseInterface(child, nsConfig);
                } else if (TAG_DHCPD_RANGE.equals(curElement)) {
                    NetworkSettingsConfigParser.parseDhcpdRange(child, nsConfig);
                } else if (TAG_OFFER_FEATURE.equals(curElement)) {
                    NetworkSettingsConfigParser.parseOfferFeature(child, nsConfig);
                } else if (TAG_REMOTE_ACCESS.equals(curElement)) {
                    NetworkSettingsConfigParser.parseRemoteAccess(child, nsConfig);
                } else {
                    throw new MalformedXMLException("Unexpected tag ??? " + curElement);
                }
            }
            ++i;
        }
    }

    private static void parseNameBundle(Node node, NetworkSettingsConfig nsConfig) throws MalformedXMLException {
        Node name = node.getAttributes().getNamedItem(ATTRIB_NAME);
        if (name == null || name.getNodeType() != 2) {
            throw new MalformedXMLException("Unable to locate name attribute on <name_bundle> element");
        }
        nsConfig.setResourceBundleName(name.getNodeValue());
    }

    private static void parseOfferFeature(Node node, NetworkSettingsConfig nsConfig) throws MalformedXMLException {
        Node name = node.getAttributes().getNamedItem(ATTRIB_NAME);
        if (name == null || name.getNodeType() != 2) {
            throw new MalformedXMLException("Unable to locate name attribute on <offer_feature> element");
        }
        String whichFeature = name.getNodeValue();
        if (whichFeature == null) {
            throw new MalformedXMLException("No value for name attribute");
        }
        if (!whichFeature.toLowerCase().equals(VALUE_LPAR_CHECKBOX)) {
            throw new MalformedXMLException("Unknown value " + whichFeature + " for " + ATTRIB_NAME + " attribute");
        }
        Node offer = node.getAttributes().getNamedItem(ATTRIB_OFFER);
        boolean offerCheckbox = offer == null || offer.getNodeValue() == null || offer.getNodeValue().toLowerCase().equals(VALUE_TRUE);
        nsConfig.setOfferLPARCheckbox(offerCheckbox);
    }

    private static void parseRemoteAccess(Node node, NetworkSettingsConfig nsConfig) {
        Node allow = node.getAttributes().getNamedItem("allow");
        boolean allowRemote = allow == null || allow.getNodeValue() == null || allow.getNodeValue().toLowerCase().equals(VALUE_TRUE);
        nsConfig.setRemoteAccess(allowRemote);
    }

    private static void parseNetApp(Node node, NetworkSettingsConfig nsConfig) throws MalformedXMLException {
        NetworkApplicationConfig naConfig = new NetworkApplicationConfig();
        Node curNode = null;
        curNode = node.getAttributes().getNamedItem(ATTRIB_APP_ID);
        if (curNode == null || curNode.getNodeType() != 2) {
            throw new MalformedXMLException("Unable to locate app_id attribute on <net_app> element");
        }
        naConfig.setApplicationID(curNode.getNodeValue());
        curNode = node.getAttributes().getNamedItem(ATTRIB_PUBLIC_DEFAULT);
        boolean publicAllow = curNode != null && curNode.getNodeValue() != null && curNode.getNodeValue().toLowerCase().equals("allow");
        naConfig.setPublicDefaultAllow(publicAllow);
        curNode = node.getAttributes().getNamedItem(ATTRIB_PRIVATE_DEFAULT);
        boolean privateAllow = curNode == null || curNode.getNodeValue() == null || curNode.getNodeValue().toLowerCase().equals("allow");
        naConfig.setPrivateDefaultAllow(privateAllow);
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeType() == 1) {
                String curElement = child.getNodeName().toLowerCase();
                if (TAG_PORT.equals(curElement)) {
                    curNode = child.getAttributes().getNamedItem(ATTRIB_NUMBER);
                    if (curNode == null || curNode.getNodeType() != 2) {
                        throw new MalformedXMLException("Unable to locate number attribute on <port> element");
                    }
                    String number = curNode.getNodeValue();
                    curNode = child.getAttributes().getNamedItem(ATTRIB_TYPE);
                    if (curNode == null || curNode.getNodeType() != 2) {
                        throw new MalformedXMLException("Unable to locate type attribute on <port> element");
                    }
                    String type = curNode.getNodeValue();
                    if (type == null) {
                        type = VALUE_TCP;
                    }
                    naConfig.addPort(new PortConfig(number, type));
                } else {
                    throw new MalformedXMLException("Unexpected tag ??? " + curElement);
                }
            }
            ++i;
        }
        nsConfig.addNetApp(naConfig);
    }

    private static void parseDhcpdRange(Node node, NetworkSettingsConfig nsConfig) throws MalformedXMLException {
        DHCPServerRangeConfig dsConfig = new DHCPServerRangeConfig();
        Node curNode = null;
        curNode = node.getAttributes().getNamedItem(ATTRIB_HMC_ADDRESS);
        if (curNode == null || curNode.getNodeType() != 2) {
            throw new MalformedXMLException("Unable to locate hmc_address attribute on <dhcpd_range> element");
        }
        dsConfig.setHmcAddress(curNode.getNodeValue());
        curNode = node.getAttributes().getNamedItem(ATTRIB_START);
        if (curNode == null || curNode.getNodeType() != 2) {
            throw new MalformedXMLException("Unable to locate start attribute on <dhcpd_range> element");
        }
        dsConfig.setStart(curNode.getNodeValue());
        curNode = node.getAttributes().getNamedItem(ATTRIB_END);
        if (curNode == null || curNode.getNodeType() != 2) {
            throw new MalformedXMLException("Unable to locate end attribute on <dhcpd_range> element");
        }
        dsConfig.setEnd(curNode.getNodeValue());
        curNode = node.getAttributes().getNamedItem(ATTRIB_SUBNET);
        if (curNode == null || curNode.getNodeType() != 2) {
            throw new MalformedXMLException("Unable to locate subnet attribute on <dhcpd_range> element");
        }
        dsConfig.setSubnet(curNode.getNodeValue());
        curNode = node.getAttributes().getNamedItem(ATTRIB_MASK);
        if (curNode == null || curNode.getNodeType() != 2) {
            throw new MalformedXMLException("Unable to locate mask attribute on <dhcpd_range> element");
        }
        dsConfig.setMask(curNode.getNodeValue());
        nsConfig.addDHCPServerRange(dsConfig);
    }

    private static void parseInterface(Node node, NetworkSettingsConfig nsConfig) throws MalformedXMLException {
        NetworkInterfaceConfig niConfig = new NetworkInterfaceConfig();
        Node curNode = null;
        curNode = node.getAttributes().getNamedItem(ATTRIB_INTERFACE_ID);
        if (curNode == null || curNode.getNodeType() != 2) {
            throw new MalformedXMLException("Unable to locate interface_id attribute on <interface> element");
        }
        niConfig.setInterfaceID(curNode.getNodeValue());
        curNode = node.getAttributes().getNamedItem(ATTRIB_TYPE);
        if (curNode == null || curNode.getNodeType() != 2) {
            niConfig.setInterfaceType(2);
        } else {
            String interfaceType = curNode.getNodeValue();
            if (interfaceType == null) {
                niConfig.setInterfaceType(2);
            } else if (interfaceType.equals(VALUE_FIXED_PUBLIC)) {
                niConfig.setInterfaceType(0);
            } else if (interfaceType.equals(VALUE_FIXED_PRIVATE)) {
                niConfig.setInterfaceType(1);
            } else {
                niConfig.setInterfaceType(2);
            }
        }
        curNode = node.getAttributes().getNamedItem(ATTRIB_IP_ADDRESS);
        if (curNode == null || curNode.getNodeType() != 2) {
            niConfig.setAddressType(3);
        } else {
            String addressType = curNode.getNodeValue();
            if (addressType == null) {
                niConfig.setAddressType(3);
            } else if (addressType.equals(VALUE_DHCP_CLIENT)) {
                niConfig.setAddressType(1);
            } else if (addressType.equals(VALUE_DHCP_SERVER)) {
                niConfig.setAddressType(2);
            } else if (addressType.equals(VALUE_FIXED)) {
                niConfig.setAddressType(0);
            } else {
                niConfig.setAddressType(3);
            }
        }
        curNode = node.getAttributes().getNamedItem(ATTRIB_VISIBLE);
        if (curNode == null || curNode.getNodeType() != 2) {
            niConfig.setVisible(true);
        } else {
            String visible = curNode.getNodeValue();
            niConfig.setVisible(visible == null || visible.equals(VALUE_TRUE));
        }
        curNode = node.getAttributes().getNamedItem(ATTRIB_LPAR_COMMUNICATION);
        if (curNode == null || curNode.getNodeType() != 2) {
            niConfig.setLparCommunication(false);
        } else {
            String lparCommunication = curNode.getNodeValue();
            niConfig.setLparCommunication(lparCommunication != null && lparCommunication.equals(VALUE_TRUE));
        }
        nsConfig.addNetworkInterface(niConfig);
    }
}

